<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pengeluarans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rolepengeluaran_id')->constrained(
                table: 'rolepengeluarans',
                indexName: 'pengeluaran_rolepengeluaran_id'
            )->onDelete('cascade');
            $table->foreignId('satuan_id')->constrained(
                table: 'satuans',
                indexName: 'pengeluaran_satuan_id'
            )->onDelete('cascade');
            $table->string('nm_barang');
            $table->integer('jml');
            $table->double('harga');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pengeluarans');
    }
};
